/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import dev.kosmx.playerAnim.core.util.Vec3d;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayer;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class EmoteHolder
implements Supplier<UUID> {
    public final KeyframeAnimation emote;
    public final class_2561 name;
    public final class_2561 description;
    public final class_2561 author;
    public AtomicInteger hash = null;
    public static UUIDMap<EmoteHolder> list = new UUIDMap();
    @Nullable
    public class_1043 nativeIcon = null;
    @Nullable
    private class_2960 iconIdentifier = null;
    @Nullable
    public INetworkInstance fromInstance = null;

    public EmoteHolder(KeyframeAnimation emote) {
        this.emote = emote;
        this.name = PlatformTools.fromJson(emote.extraData.get("name"));
        this.description = PlatformTools.fromJson(emote.extraData.get("description"));
        this.author = PlatformTools.fromJson(emote.extraData.get("author"));
    }

    @Deprecated
    public EmoteHolder(KeyframeAnimation emote, class_2561 name, class_2561 description, class_2561 author, int hash) {
        this.emote = emote;
        this.name = name;
        this.author = author;
        this.description = description;
    }

    public static void clearEmotes() {
        list.removeIf(emoteHolder -> {
            if (emoteHolder.fromInstance != null) {
                return false;
            }
            if (emoteHolder.iconIdentifier != null) {
                class_310.method_1551().method_1531().method_4615(emoteHolder.iconIdentifier);
                assert (emoteHolder.nativeIcon != null);
                emoteHolder.nativeIcon.close();
            }
            return true;
        });
    }

    public class_2960 getIconIdentifier() {
        block3: {
            if (this.iconIdentifier == null && this.emote.extraData.containsKey("iconData")) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(Objects.requireNonNull(AbstractNetworkInstance.safeGetBytesFromBuffer((ByteBuffer)this.emote.extraData.get("iconData"))));
                    this.assignIcon(stream);
                    ((InputStream)stream).close();
                }
                catch (IOException | NullPointerException e) {
                    EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
                    if (((ClientConfig)EmoteInstance.config).neverRemoveBadIcon.get().booleanValue()) break block3;
                    this.emote.extraData.remove("iconData");
                }
            }
        }
        return this.iconIdentifier;
    }

    public void assignIcon(InputStream inputStream) {
        try {
            class_1043 nativeImageBackedTexture = new class_1043(class_1011.method_4309((InputStream)inputStream));
            this.iconIdentifier = PlatformTools.newIdentifier("icon" + this.hashCode());
            class_310.method_1551().method_1531().method_4616(this.iconIdentifier, (class_1044)nativeImageBackedTexture);
            this.nativeIcon = nativeImageBackedTexture;
        }
        catch (Throwable var) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "Can't open emote icon: " + String.valueOf(var));
            this.iconIdentifier = null;
            this.nativeIcon = null;
        }
    }

    public KeyframeAnimation getEmote() {
        return this.emote;
    }

    public static EmoteHolder getEmoteFromUuid(UUID uuid) {
        return (EmoteHolder)list.get((Object)uuid);
    }

    public static void addEmoteToList(Iterable<KeyframeAnimation> emotes) {
        for (KeyframeAnimation emote : emotes) {
            list.add((Supplier)new EmoteHolder(emote));
        }
    }

    public static EmoteHolder addEmoteToList(KeyframeAnimation emote) {
        EmoteHolder newEmote = new EmoteHolder(emote);
        EmoteHolder old = newEmote.findIfPresent();
        if (old == null) {
            list.add((Supplier)newEmote);
            return newEmote;
        }
        return old;
    }

    EmoteHolder findIfPresent() {
        if (list.contains((Supplier)this)) {
            for (EmoteHolder obj : list) {
                if (!obj.equals(this)) continue;
                return obj;
            }
        }
        return null;
    }

    @Deprecated
    public static void addEmoteToList(EmoteHolder hold) {
        list.add((Supplier)hold);
    }

    public static boolean playEmote(KeyframeAnimation emote, IEmotePlayerEntity player) {
        return EmoteHolder.playEmote(emote, player, null);
    }

    public static boolean playEmote(KeyframeAnimation emote, IEmotePlayerEntity player, @Nullable EmoteHolder emoteHolder) {
        if (EmoteHolder.canPlayEmote(player)) {
            return ClientEmotePlay.clientStartLocalEmote(emote);
        }
        return false;
    }

    private static boolean canPlayEmote(IEmotePlayerEntity entity) {
        if (!EmoteHolder.canRunEmote(entity)) {
            return false;
        }
        if (!entity.isMainPlayer()) {
            return false;
        }
        return !IEmotePlayer.isRunningEmote(entity.emotecraft$getEmote()) || entity.emotecraft$getEmote().isLoopStarted();
    }

    public static boolean canRunEmote(IEmotePlayerEntity player) {
        if (!TmpGetters.getClientMethods().isAbstractClientEntity(player)) {
            return false;
        }
        if (player.emotecraft$isNotStanding() && !ClientPacketManager.isRemoteTracking()) {
            return false;
        }
        Vec3d prevPos = player.emotecraft$getPrevPos();
        return !(player.emotecraft$emotesGetPos().distanceTo(new Vec3d((Double)prevPos.getX(), Double.valueOf(MathHelper.lerp((double)((ClientConfig)EmoteInstance.config).yRatio.get().floatValue(), (double)((Double)prevPos.getY()), (double)((Double)player.emotecraft$emotesGetPos().getY()))), (Double)prevPos.getZ())) > (double)((ClientConfig)EmoteInstance.config).stopThreshold.get().floatValue());
    }

    public boolean playEmote(IEmotePlayerEntity playerEntity) {
        return EmoteHolder.playEmote(this.emote, playerEntity, this);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = new AtomicInteger(this.emote.hashCode());
        }
        return this.hash.get();
    }

    public UUID getUuid() {
        return this.emote.getUuid();
    }

    public boolean equals(Object o) {
        if (o instanceof EmoteHolder) {
            return this.emote.equals((Object)((EmoteHolder)o).emote);
        }
        return false;
    }

    @Override
    public UUID get() {
        return this.emote.get();
    }

    public static void handleKeyPress(class_3675.class_306 key) {
        EmoteHolder emoteHolder;
        UUID uuid;
        if (EmoteInstance.instance != null && EmoteHolder.canRunEmote(TmpGetters.getClientMethods().getMainPlayer()) && (uuid = ((ClientConfig)EmoteInstance.config).emoteKeyMap.getL(key)) != null && (emoteHolder = (EmoteHolder)list.get((Object)uuid)) != null) {
            ClientEmotePlay.clientStartLocalEmote(emoteHolder);
        }
    }

    public static EmoteHolder getNonNull(@Nonnull UUID emote) {
        EmoteHolder emoteHolder = (EmoteHolder)list.get((Object)emote);
        if (emoteHolder == null) {
            return new Empty(emote);
        }
        return emoteHolder;
    }

    public static class Empty
    extends EmoteHolder {
        public Empty(UUID uuid) {
            super(new KeyframeAnimation.AnimationBuilder(AnimationFormat.UNKNOWN).setName("{\"color\":\"red\",\"text\":\"INVALID\"}").setUuid(uuid).build());
        }
    }
}

